//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AIScanMain.h"
#include "drvlinx.h"   /* DriverLINX API */
#include "dlcodes.h"   /* DriverLINX error codes and macros */
// be sure to add drvlnxbc.lib to the project

// DriverLINX variables and function prototypes

DL_SERVICEREQUEST SR;    // declare the Service Request Structure
HANDLE hInstance;       // instance handle for the driver
HANDLE hWin;           // handle to this application
unsigned long DLMsg; // an unsigned variable to hold the
                     // the value assigned by RegisterWindowMessage()
// variables used for error handling
char errString[100];
DWORD size=50;
int errNumber;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cmdOpenClick(TObject *Sender)
{
       // get the handle of this application's window
      hWin = Form1->Handle;
// a window handle to this application will be necessary for processing
// of any windows messages sent by DriverLINX.  For POLLED mode
// tasks, this is not so useful, but for INTERRUPT OR DMA tasks, the
// BufferFilled or ServiceDone messages are very helpful for control of
// program flow.  Use of delay timers not necessary.

	// call OpenDriverLINX()
	hInstance = (HANDLE)OpenDriverLINX( hWin, "kmb1700" );
        // if not using one of the DAS-1700 Series boards,
        // replace the kmb1700 with the name of your driver.

       // get a unique identifier from Windows for DriverLINX messages
       DLMsg = RegisterWindowMessage(DL_MESSAGE);
        
       Form1->SetFocus();  // set focus back to our application

       // enable next command button
       cmdInit->Enabled = True;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::cmdInitClick(TObject *Sender)
{
     	memset( &SR, 0, sizeof( DL_SERVICEREQUEST ) );
	DL_SetServiceRequestSize( SR );

	SR.hWnd = hWin;
        SR.operation = INITIALIZE;  // carry out an initialization operation
	SR.device = 0;  // the device number as assigned in DLinx Config Panel
	SR.subsystem = DEVICE;
	SR.mode = OTHER;
    	// call DriverLINX() to execute the task specified by the
        // members of the SR structure
	if( DriverLINX( &SR ) != NoErr )
         { // respond to error
         cmdAcquire->Enabled = False;
         errNumber = getErrCode(SR.result);
        // errNumber corresponds to DriverLINX documentation
        ReturnMessageString(SR.hWnd,SR.result,errString,size);
        // errString corresponds to DriverLINX documentation
        lblStatus->Caption = errString;
         }
        else
        {
        // no error on Init operation, enable acquisition
        cmdAcquire->Enabled = True;
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::cmdAcquireClick(TObject *Sender)
{
        // clear the list box
        ListBox1->Clear();
        // set up a buffered AI task
   	SR.hWnd = hWin;
	SR.device = 0;
	SR.subsystem = AI; // use the Analog Input subsystem of the board
	SR.mode = INTERRUPT;  // could be DMA if board has this feature
	SR.operation=START; //this is a Start operation
	SR.start.typeEvent=COMMAND; //Start on command
        SR.stop.typeEvent = TCEVENT;  // Stop automatically when the buffer is filled
	SR.timing.typeEvent=RATEEVENT; //timing will be determined by the rate generator
	SR.stop.typeEvent=TCEVENT; //Stop automatically when buffer is full
	SR.channels.nChannels=2; //A start stop channel range will be used
	SR.channels.chanGain[0].channel=0; //starting channel is 0
	SR.channels.chanGain[0].gainOrRange=Gain2Code(0,AI,-1.0); //Use bipolar unity gain
        SR.channels.chanGain[1].channel=7;  // stop on chan 7
	SR.channels.chanGain[1].gainOrRange=Gain2Code(0,AI,-1.0);
	SR.channels.numberFormat=tNATIVE; //use the native format (integer counts)
	SR.lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)]; //create a buffer list pointer for one buffer
	SR.lpBuffers->notify=NOTIFY; //enable the buffer filled message
	SR.lpBuffers->nBuffers=1; //use only one buffer
	SR.lpBuffers->bufferSize=Samples2Bytes(0,AI,0,8); //set the size of the buffer (in bytes) to hold the 8 samples
	SR.lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,SR.lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified
	SR.timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER is a symbol representing the default counter/timer channel used for pacing.
	SR.timing.u.rateEvent.mode=RATEGEN;
	SR.timing.u.rateEvent.clock=INTERNAL1;  //Internal clocking will be used
	SR.timing.u.rateEvent.gate=NOCONNECT; //no gating will be used
	SR.timing.u.rateEvent.period=Sec2Tics(0,AI,INTERNAL1,0.01f); //100 Hz
	//Execute the service request to start the acquisition
        if( DriverLINX( &SR ) != NoErr )
         { // respond to error
         errNumber = getErrCode(SR.result);
        // errNumber corresponds to DriverLINX documentation
        ReturnMessageString(SR.hWnd,SR.result,errString,size);
        // errString corresponds to DriverLINX documentation
        lblStatus->Caption = errString;
         }
        else
        {
        lblStatus->Caption = "Acquisition Started...";
         }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::WndProc(Messages::TMessage &Message)
{
  if ( Message.Msg == DLMsg) // first test to see if this is from DriverLINX
    {
       switch(Message.WParam)  // if so, which DriverLINX message?
       {
        case DL_SERVICEDONE:
        //lblStatus->Caption = "Service Done Message Posted";
        Beep();
        break;
        case DL_BUFFERFILLED:
        lblStatus->Caption = "Buffer Filled Message Posted";
        // call a function to process the data
        convertData();
        break;
        case DL_DATALOST:
        // Place code here to restart the task or call for help
        break;
        }  // switch
    } // if

  // maybe the message was not for DriverLINX at all......
  TForm::WndProc( Message );  // call Default message handler for TForm class.
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CleanUpDriverLINX(TObject *Sender)
{
	clearBuffers(); //de-allocate any existing buffers
	CloseDriverLINX(hInstance); //close the DriverLINX driver
	hInstance=NULL; //for safety, make sure hInstance isn't pointing to anything
	delete(&SR); //de-allocate the memory used by the service request
	//SR=NULL;
}
//---------------------------------------------------------------------------
 void __fastcall TForm1::clearBuffers()
 {
     	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(&SR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(SR.lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to
			a buffer?*/
			if(SR.lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(SR.lpBuffers->BufferAddr[0]);
				SR.lpBuffers->BufferAddr[0]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(SR.lpBuffers);
			SR.lpBuffers=NULL;
		}
	}
  }
//---------------------------------------------------------------------------
void __fastcall TForm1::convertData()
{
// allocate an array to hold the 8 data points
        float *DataArray;
        DataArray = new float[8];

 SR.operation=CONVERT; //Do a convert operation
 SR.mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
 SR.start.typeEvent=DATACONVERT; //Set the start type to convert the data
 SR.start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
 SR.start.u.dataConvert.nSamples=8; //set the number of samples to convert
 SR.start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
 SR.start.u.dataConvert.scaling=0.0f; //no scaling will be used
 SR.start.u.dataConvert.offset=0.0f; //no offset will be applied
 SR.start.u.dataConvert.wBuffer=0; //convert DriverLINX buffer 0, since that's the only one being used
 SR.start.u.dataConvert.lpBuffer=DataArray; //put the converted readings in the temporary buffer
 DriverLINX(&SR); //Execute the conversion

// put the data into the Form1's ListBox control
int i;
char str[25];
char fullStr[25];

for(i=0;i<8;i++)
{
   gcvt(DataArray[i], 4, str); // convert DataArray element to string
   ListBox1->Items->Add(str);  // populate listbox
}
// dispose of the local array
delete [] DataArray;
}
//---------------------------------------------------------------------------

